<?php
/**
 *
 * Let's Review Visitors Class
 *
 * @since      2.0.0
 *
 * @package    Let's Review
 * @subpackage lets-review/frontend
 */

class Lets_Review_Visitors {

	/**
	 * Var for Let's Review slug.
	 *
	 * @since    2.0.0
	 */
	private $slug;

	/**
	 * Var for Let's Review version.
	 *
	 * @since    2.0.0
	 */
	private $version;

	/**
	 * Var for Let's Review URL.
	 *
	 * @since    2.0.0
	 */
	private $url;

	/**
	 * Frontend Constructor
	 *
	 * @since 2.0.0
	 *
	*/
	public function __construct( $slug = '', $version = '', $url = '' ) {
		$this->slug    = $slug;
		$this->version = $version;
		$this->url     = $url;
	}

	private function lets_review_ur_up_down( $args = array() ) {
		if ( get_option( 'lets_review_comments_up_down', true ) != true && empty( $args['override'] ) ) {
			return;
		}
		ob_start();
		?>
		<div class="lets-review-block__wrap-51 lr-cf" data-cid="<?php echo esc_attr( $args['cid'] ); ?>">
			<a class="lets-review__up-down lets-review__up lr-vc lr-tip" data-title="<?php esc_attr_e( 'Helpful', 'lets-review' ); ?>" href="#" data-type="up"><span class="updown-i lr-all-c"><svg width="15px" height="15px" viewBox="0 0 22 22" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><path d="M21.3670886,8.2 C20.8607595,7.6 20.1518987,7.1 19.3417722,7 C19.1392405,7 19.0379747,7 18.835443,7 L14.1772152,7 L14.1772152,4 C14.1772152,1.8 12.3544304,0 10.1265823,0 C9.72151899,0 9.3164557,0.2 9.21518987,0.6 L5.46835443,9 L3.03797468,9 C1.3164557,9 0,10.3 0,12 L0,19 C0,20.7 1.3164557,22 3.03797468,22 L17.5189873,22 C17.5189873,22 17.5189873,22 17.5189873,22 C19.0379747,22 20.2531646,20.9 20.556962,19.5 L21.9746835,10.5 C22.0759494,9.7 21.8734177,8.9 21.3670886,8.2 Z M5.06329114,20 L3.03797468,20 C2.43037975,20 2.02531646,19.6 2.02531646,19 L2.02531646,12 C2.02531646,11.4 2.43037975,11 3.03797468,11 L5.06329114,11 L5.06329114,20 Z M18.5316456,19.2 C18.4303797,19.7 18.0253165,20 17.5189873,20 L7.08860759,20 L7.08860759,10.2 L10.7341772,2.1 C11.5443038,2.4 12.1518987,3.1 12.1518987,4 L12.1518987,8 C12.1518987,8.6 12.556962,9 13.164557,9 L18.9367089,9 C19.0379747,9 19.0379747,9 19.1392405,9 C19.443038,9 19.6455696,9.2 19.8481013,9.4 C20.0506329,9.6 20.0506329,9.9 20.0506329,10.1 L18.5316456,19.2 Z" fill="#444444"></path></svg></span><span class="updown-count"><?php echo (int) $args['upDown']['up']; ?></span></a>
			<a class="lets-review__up-down lets-review__down lr-vc lr-tip" data-title="<?php esc_attr_e( 'Not helpful', 'lets-review' ); ?>" href="#" data-type="down"><span class="updown-i lr-all-c"><svg width="15px" height="15px" viewBox="0 0 22 22" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><path d="M22,2.91324201 C21.7974539,1.20547945 20.3796316,0 18.6579901,0 C18.6579901,0 18.6579901,0 18.5567171,0 L4.47976639,0 C4.47976639,0 4.47976639,0 4.47976639,0 C2.96067099,0 1.74539467,1.10502283 1.44157559,2.51141553 L0.0237532155,11.5525114 C-0.178792838,13.1598174 0.935210455,14.7671233 2.55557888,14.9680365 C2.75812494,14.9680365 2.85939796,14.9680365 3.06194402,14.9680365 L7.82177627,14.9680365 L7.82177627,17.9817352 C7.82177627,20.1917808 9.64469075,22 11.8726973,22 C12.2777894,22 12.6828815,21.7990868 12.7841546,21.3972603 L16.5312566,12.9589041 L18.5567171,12.9589041 C20.2783585,12.9589041 21.6961809,11.7534247 21.898727,10.0456621 C21.898727,10.0456621 21.898727,9.94520548 21.898727,9.94520548 L21.898727,3.01369863 C22,3.01369863 22,2.91324201 22,2.91324201 Z M14.9108881,11.8538813 L11.2650592,19.9908676 C10.454875,19.6894977 9.8472368,18.9863014 9.8472368,18.0821918 L9.8472368,14.0639269 C9.8472368,13.4611872 9.44214469,13.0593607 8.83450653,13.0593607 L3.06194402,13.0593607 C3.06194402,13.0593607 2.96067099,13.0593607 2.85939796,13.0593607 C2.35303283,12.9589041 1.94794072,12.456621 2.04921375,11.9543379 L3.46703612,2.91324201 C3.56830915,2.4109589 3.97340126,2.00913242 4.47976639,2.00913242 C4.47976639,2.00913242 4.47976639,2.00913242 4.47976639,2.00913242 L14.9108881,2.00913242 L14.9108881,11.8538813 Z M19.9745395,9.94520548 C19.8732664,10.5479452 19.2656283,11.0502283 18.6579901,11.0502283 L16.9363487,11.0502283 L16.9363487,2.00913242 L18.6579901,2.00913242 C18.6579901,2.00913242 18.6579901,2.00913242 18.6579901,2.00913242 C19.2656283,2.00913242 19.8732664,2.51141553 19.9745395,3.11415525 L19.9745395,9.94520548 Z" fill="#444444"></path></svg></span><span class="updown-count"><?php echo (int) $args['upDown']['down']; ?></span></a>
		</div>
		<?php
		return ob_get_clean();
	}

	private function lets_review_ur_criterias_block( $args = array() ) {
		if ( empty( $args['crits'] ) ) {
			return;
		}
		$crits           = Lets_Review_Helpers::lets_review_get_convert_to_all_scores(
			array(
				'score'     => $args['crits'],
				'scoreType' => $args['scoreType'],
			)
		);
		$score_type_prop = 2 == $args['format_output'] ? 'outof10' : 'outof100';
		$score_type_prop = $args['format_output'] > 2 ? 'outof5' : $score_type_prop;
		$crit_args       = array(
			'design'         => 1,
			'reviewType'     => 3,
			'scoreType'      => $args['format_output'],
			'comment_review' => true,
			'accent'         => $args['accent'],
			'max'            => $args['max'],
			'scoreTypeProp'  => $score_type_prop,
			'crits'          => $crits,
		);
		$blocks          = new Lets_Review_Blocks();
		ob_start();
		?>
		<div class="lets-review-block__wrap-50 lets-review-block__wrap lr-cf lets-review-score-type-<?php echo (int) $args['format_output']; ?>">
			<div class="lets-review-breakdown"><?php esc_html_e( 'Breakdown', 'lets-review' ); ?></div>
			<?php $blocks->lets_review_crits( $crit_args ); ?>
		</div>
		<?php
		return ob_get_clean();
	}
	/**
	 * Comment Text
	 *
	 * @since 3.0.0
	 */
	public function lets_review_comment_text( $comment_text = '', $comment = '' ) {
		if ( empty( $comment ) || empty( $comment->comment_approved ) || empty( $comment->comment_post_ID ) ) {
			return $comment_text;
		}
		$pid            = $comment->comment_post_ID;
		$args           = array();
		$args['cid']    = $comment->comment_ID;
		$args['upDown'] = get_comment_meta( $args['cid'], 'lets_review_ur_up_down', true );
		$args['upDown'] = empty( $args['upDown'] ) ? array(
			'up'   => 0,
			'down' => 0,
		) : $args['upDown'];
		if ( get_post_meta( $pid, '_lets_review_onoff', true ) != 1 || is_admin() || ! empty( $comment->comment_parent ) ) {
			if ( get_option( 'lets_review_comments_normal_up_down' ) == true ) {
				$args['override'] = true;
				return $comment_text . $this->lets_review_ur_up_down( $args );
			} else {
				return $comment_text;
			}
		}
		if ( get_option( 'lets_review_gen_user_reviews' ) != 1 && 10 != get_post_meta( $pid, '_lets_review_type', true ) ) {
			return $comment_text;
		}

		$args['onOff']      = get_comment_meta( $args['cid'], 'lets_review_ur_onoff', true );
		$args['scoreType']  = get_comment_meta( $args['cid'], 'lets_review_ur_format', true );
		$args['crits']      = get_comment_meta( $args['cid'], 'lets_review_ur_criterias', true );
		$args['temp_score'] = get_comment_meta( $args['cid'], 'lets_review_ur_f_score', true );
		$args['reviewType'] = 1;
		$args               = Lets_Review_Helpers::lets_review_args( $args );

		$headline = get_comment_meta( $args['cid'], 'lets_review_ur_headline', true );
		if ( ! array_filter( $args ) || ! isset( $args['temp_score'] ) || ( isset( $args['temp_score'] ) && '' === $args['temp_score'] ) ) {
			return $comment_text;
		}
		$args['score'] = Lets_Review_Helpers::lets_review_get_convert_to_all_scores(
			array(
				'score'     => $args['temp_score'],
				'scoreType' => $args['scoreType'],
				'max'       => $args['max'],
			)
		);

		if ( $args['scoreType'] > 2 ) {
			$args['score'][ $args['scoreTypeProp'] ] = number_format( $args['score'][ $args['scoreTypeProp'] ], 1 ) + 0;
		}
		$args['accent'] = Lets_Review_Helpers::lets_review_get_accent(
			array(
				'pid' => $pid,
			)
		);
		$format         = get_post_meta( $pid, '_lets_review_format', true );
		$args['max']    = 100;
		if ( 2 == $format ) {
			$args['max'] = 10;
		} elseif ( $format > 2 ) {
			$args['max'] = 5;
		}
		$args['format_output'] = $format;
		$design_skin           = get_post_meta( $pid, '_lets_review_design_skin', true ) ? get_post_meta( $pid, '_lets_review_design_skin', true ) : 1;

		$comment_text     .= $this->lets_review_ur_criterias_block( $args );
		$comment_text     .= $this->lets_review_ur_up_down( $args );
		$score_type_output = 2 == $format ? 'outof10' : 'outof100';
		$score_type_output = $format > 2 ? 'outof5' : $score_type_output;
		$f_score_output    = '';
		if ( isset( $args['score'][ $score_type_output ] ) && '' !== $args['score'][ $score_type_output ] ) {
			$f_score_output  = '<div class="lets-review-ur-f-wrap lr-font-h lets-review-score-type-' . $format . '" style="background: ' . esc_attr( $args['accent'] ) . ' ;">';
			$f_score_output .= '<div class="lets-review-ur-value score" >' . (float) $args['score'][ $score_type_output ] . '</div>';
			$f_score_output .= '</div>';
		}

		if ( ! empty( $headline ) ) {
			$f_score_output .= '<div class="lets-review-ur-headline lr-font-h">' . lets_review_sanitize_wp_kses( $headline ) . '</div>';
		}

		return $f_score_output . $comment_text;
	}

	/**
	 * Save
	 *
	 * @since 2.0.0
	 */
	public function lets_review_insert( $id, $comment ) {
		if ( ( get_option( 'lets_review_gen_user_reviews' ) != 1 && 10 != get_post_meta( $comment->comment_post_ID, '_lets_review_type', true ) ) || get_post_meta( $comment->comment_post_ID, '_lets_review_onoff', true ) != 1 ) {
			return;
		}
		$on_ff   = empty( $_POST['lets_review_ur_onoff'] ) ? '' : $_POST['lets_review_ur_onoff'];
		$f_score = ! isset( $_POST['lets_review_final_score'] ) ? '' : (int) $_POST['lets_review_final_score'];

		if ( '' === $f_score || 'off' == $on_ff ) {
			return;
		}

		if ( ! empty( $_POST['lets_review_ur_criterias'] ) ) {
			$i               = 1;
			$sanitized_array = array();
			foreach ( $_POST['lets_review_ur_criterias'] as $key => $value ) {
				$sanitized_array[ $i ] = array(
					'title' => wp_kses_data( $key ),
					'score' => floatval( $value ),
				);
				$i++;
			}

			add_comment_meta( $id, 'lets_review_ur_criterias', $sanitized_array );
		}

		if ( ! empty( $_POST['lets_review_ur_headline'] ) ) {
			add_comment_meta( $id, 'lets_review_ur_headline', wp_kses_data( $_POST['lets_review_ur_headline'] ) );
		}

		add_comment_meta( $id, 'lets_review_ur_format', intval( $_POST['lets_review_ur_format'] ) );
		add_comment_meta( $id, 'lets_review_ur_f_score', floatval( $f_score ) );

	}

	/**
	 * Comment Form
	 *
	 * @since 2.0.0
	 */
	public function lets_review_form() {

		global $post;
		$pid = $post->ID;
		if ( ( get_option( 'lets_review_gen_user_reviews' ) != 1 && 10 != get_post_meta( $pid, '_lets_review_type', true ) ) || get_post_meta( $pid, '_lets_review_onoff', true ) != 1 ) {
			return;
		}

		/*
		only one user
		global $current_user;
		$args = array('user_id' => $current_user->ID);
		$usercomment = get_comments($args);
		if(count($usercomment) >= 1){
		echo 'disabled';
		} else {
		comment_form();
		}
		*/

		$options     = get_post_meta( $pid, '_lets_review_criterias', true );
		$options     = empty( $options ) ? get_option( 'lets_review_criterias' ) : $options;
		$format      = get_post_meta( $pid, '_lets_review_format', true );
		$format      = empty( $format ) ? get_option( 'lets_review_gd_format' ) : $format;
		$design      = get_post_meta( $pid, '_lets_review_design', true );
		$design      = empty( $design ) ? get_option( 'lets_review_gd_design' ) : $design;
		$color       = get_post_meta( $pid, '_lets_review_color', true );
		$color       = empty( $color ) ? get_option( 'lets_review_gd_color' ) : $color;
		$design_skin = get_post_meta( $pid, '_lets_review_design_skin', true );
		$design_skin = empty( $design_skin ) ? get_option( 'lets_review_gd_skin' ) : $design_skin;
		$max         = 5;
		$step        = 0.1;
		$mid_score   = 2.5;
		if ( $format == 1 ) {
			$max       = 100;
			$step      = 1;
			$mid_score = 50;
		} elseif ( $format == 2 ) {
			$max       = 10;
			$mid_score = 5;
		}
		$mid_score          = apply_filters( 'lets_review_user_comment_review_default_score', $mid_score );
		$step               = apply_filters( 'lets_review_comment_reviews_step', $step, $pid );
		$user_default_onoff = get_option( 'lets_review_gen_user_review_onoff_default', 1 );
		?>
		<p class="lets-review-form-onoff lr-cf">
			<label><?php esc_html_e( 'Is this a review?', 'lets-review' ); ?></label>
			<label class="lets-review-ur-onoff-label lr-cf">
				<input type="radio" name="lets_review_ur_onoff" value="off"
				<?php
				if ( $user_default_onoff != 2 ) {
					?>
					checked="checked"<?php } ?> class="lets-review-ur-onoff" />
				<span class="lets-review-no" for="lets_review_ur_onoff"><?php esc_html_e( 'No', 'lets-review' ); ?></span>
			  </label>
			  <label class="lets-review-ur-onoff-label lr-cf">
				<input type="radio" name="lets_review_ur_onoff" value="on"
				<?php
				if ( $user_default_onoff == 2 ) {
					?>
					checked="checked"<?php } ?> class="lets-review-ur-onoff" />
			   <span class="lets-review-yes" for="lets_review_ur_onoff"><?php esc_html_e( 'Yes', 'lets-review' ); ?></span>
			  </label>
		</p>
		<p class="lets-review-form
		<?php
		if ( $user_default_onoff == 2 ) {
			?>
			 lets-review-form-show<?php } ?>"><label for="lets_review_ur_headline"><?php esc_html_e( 'Review Headline', 'lets-review' ); ?></label> <input name="lets_review_ur_headline" type="text" value="" size="30" aria-required="true"></p>
		<input name="lets_review_ur_format" type="hidden" value="<?php echo (int) $format; ?>">
		<div class="lets-review-form
		<?php
		if ( $user_default_onoff == 2 ) {
			?>
			 lets-review-form-show<?php } ?> lets-review-form-crits lr-cf cb-skin-base cb-lr-font-p cb-lr-font-p cb-design-3 cb-skin-version-<?php echo esc_attr( $design_skin ); ?> lr-cf" data-max="<?php echo (int) $max; ?>" data-value="<?php echo (int) $mid_score; ?>" data-step="<?php echo floatval( $step ); ?>">
		<?php if ( ! empty( $options ) ) { ?>
			<div class="lets-review-all-crits lr-cf">
				<?php $i = 1; ?>
				<?php foreach ( $options as $key ) { ?>
					<div class="cb-bar">
						<span class="cb-criteria-title"><?php echo esc_attr( $key['title'] ); ?></span>
					<div class="cb-criteria-score lr-cf">
						<div class="cb-review-slider lets-review-c-slider" data-color="<?php echo esc_attr( $color ); ?>"></div>
						<input type="number" step="<?php echo (float) $step; ?>" value="<?php echo (float) $mid_score; ?>" name="lets_review_ur_criterias[<?php echo esc_attr( $key['title'] ); ?>]" class="lr-input-score cb-cri-score lets-review-ind-crit cb-input" data-format="<?php echo (int) $format; ?>">
					</div>
					<?php $i++; ?>
					</div>
				<?php } ?>
			</div> <!-- .lets-review-all-crits -->
		<?php } ?>
			<div class="cb-bar cb-final-score-wrap">
				<div class="cb-criteria-title">
					<span class="cb-list-title"><?php esc_html_e( 'Final Score', 'lets-review' ); ?></span>
				</div>
				<div class="cb-criteria-score lr-cf">
					<div class="cb-review-slider lets-review-c-slider" data-color="<?php echo esc_attr( $color ); ?>"></div>
					<input type="number" step="<?php echo (float) $step; ?>" value="<?php echo (float) $mid_score; ?>" name="lets_review_final_score" class="lets-review-final-score lr-input-score cb-cri-score cb-input">
					<input type="hidden" value="50" name="lets_review_final_score_100" class="lets-review-100">
				</div>
			</div>
		</div>
		<?php
	}
}
